<?php

namespace Plenty\Modules\Order\Models;

use Illuminate\Database\Eloquent\Model;

class OrderAmount extends Model 
{

    protected $table = 'plenty_order_amount';
    public $timestamps = true;
    protected $guarded = array('id');
    protected $fillable = array('orderId', 'isSystemCurrency', 'isNet', 'currency', 'exchangeRatio', 'netTotal', 'grossTotal', 'vatTotal', 'invoiceTotal', 'paidAmount', 'prepaidAmount');
    protected $visible = array('id', 'orderId', 'isSystemCurrency', 'isNet', 'currency', 'exchangeRatio', 'netTotal', 'grossTotal', 'vatTotal', 'invoiceTotal', 'paidAmount', 'prepaidAmount', 'updatedAt', 'createdAt');

    public function vats()
    {
        return $this->hasMany('OrderAmountVat', 'orderAmountId', 'id');
    }

}